<?php

namespace App\Http\Controllers;

use Illuminate\Http\RedirectResponse;

class PrescriptionController extends Controller
{
    public function approve(string $reference): RedirectResponse
    {
        $result = \approvePrescription($reference);

        if ($result['success'] ?? false) {
            return redirect()->route('prescriptions.show', $reference)
                ->with('success', $result['message'] ?? 'Prescription approuvée avec succès.');
        }

        return redirect()->route('prescriptions.show', $reference)
            ->with('error', $result['message'] ?? 'Échec de l\'approbation de la prescription.');
    }

    public function cancel(string $reference): RedirectResponse
    {
        $result = \cancelPrescription($reference);

        if ($result['success'] ?? false) {
            return redirect()->route('prescriptions.show', $reference)
                ->with('success', $result['message'] ?? 'Prescription annulée avec succès.');
        }

        return redirect()->route('prescriptions.show', $reference)
            ->with('error', $result['message'] ?? 'Échec de l\'annulation de la prescription.');
    }

    public function finish(string $reference): RedirectResponse
    {
        $result = \finishPrescription($reference);

        if ($result['success'] ?? false) {
            return redirect()->route('prescriptions.show', $reference)
                ->with('success', $result['message'] ?? 'Prescription terminée avec succès.');
        }

        return redirect()->route('prescriptions.show', $reference)
            ->with('error', $result['message'] ?? 'Échec de la finalisation de la prescription.');
    }
}
