<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;

class SubscriptionController extends Controller
{
    /**
     * Store a new subscription
     * @param Request $request
     * @return RedirectResponse
     */
    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'code' => 'required|string|min:12|max:15',
        ]);

        $result = activateSubscription($request->code);

        if ($result['success']) {
            // Sync the subscription history to get the newly activated subscription
            syncSubscriptionHistory();
            return redirect()->route('subscriptions.index')->with('success', $result['message']);
        } else {
            return redirect()->route('subscriptions.index')->with('error', $result['error']);
        }
    }
}
