<?php

namespace App\Livewire\Account;

use App\Models\User;
use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Layout;

#[Layout('layouts.dashboard')]
class Index extends Component
{
    /**
     * The authenticated user viewing their account dashboard.
     */
    public User $user;

    public function mount(): void
    {
        $this->user = Auth::user();
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('dashboard.account.index', [
            'user' => $this->user,
        ]);
    }
}


