<?php

namespace App\Livewire\Customers;

use App\Models\Customer;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.dashboard')]
class Show extends Component
{
    public Customer $customer;

    public function mount(Customer $customer)
    {
        $this->customer = $customer->load(['contact', 'address', 'sales' => function ($query) {
            $query->latest()->limit(5);
        }, 'debtRecords' => function ($query) {
            $query->latest()->limit(5);
        }]);
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.customers.show');
    }
}
