<?php

namespace App\Livewire\Dashboard;

use Livewire\Component;

class LatestPrescriptionTable extends Component
{
    public array $prescriptions = [];

    public bool $loading = false;

    public ?string $errorMessage = null;

    public int $limit = 5;

    public function mount(): void
    {
        $this->loadLatestPrescriptions();
    }

    public function loadLatestPrescriptions(): void
    {
        $this->loading = true;
        $this->errorMessage = null;

        $response = \getApiLatestPrescriptions($this->limit);

        if ($response['success'] ?? false) {
            $this->prescriptions = $response['data'] ?? [];
        } else {
            // Silently fail - don't show error to user, just show empty state
            $this->prescriptions = [];
            $this->errorMessage = $response['message'] ?? null;
        }

        $this->loading = false;
    }

    public function refreshPrescriptions(): void
    {
        $this->loadLatestPrescriptions();
    }

    public function render()
    {
        return view('livewire.dashboard.latest-prescription-table');
    }
}
