<?php

namespace App\Livewire\ExpenseCategories;

use App\Models\ExpenseCategory;
use Livewire\Component;
use Livewire\Attributes\Layout;

#[Layout('layouts.dashboard')]
class Show extends Component
{
    public ExpenseCategory $category;

    public function mount(ExpenseCategory $category): void
    {
        $this->category = $category->load(['expenses'])->loadCount('expenses');
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.expense-categories.show');
    }
}
