<?php

namespace App\Livewire\Merchant;

use Livewire\Component;

class ModalActivate extends Component
{
    public bool $error = false;

    public string $error_message = '';

    public bool $activating = false;

    public function activate(): void
    {
        $this->activating = true;
        $this->error = false;
        $this->error_message = '';

        $result = activateMerchant();

        if (! $result['success']) {
            $this->error = true;
            $this->error_message = $result['message'] ?? 'Échec de l\'activation';
            $this->activating = false;

            return;
        }

        $this->activating = false;
        session()->flash('success', 'Établissement activé avec succès.');
        $this->dispatch('merchant-activated');
        $this->dispatch('close-modal');
    }

    public function render()
    {
        return view('livewire.merchant.modal-activate');
    }
}
