<?php

namespace App\Livewire\Merchant;

use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.dashboard')]
class Show extends Component
{
    public array $merchantInfo = [];

    public function mount(): void
    {
        $result = getAndSyncMerchant();

        if (! ($result['success'] ?? false)) {
            session()->flash('error', $result['error'] ?? 'Impossible de charger les informations de la pharmacie.');
        }

        if ($result['offline_mode'] ?? false) {
            session()->flash('warning', $result['message'] ?? 'Mode hors ligne activé');
        }

        $this->merchantInfo = [
            'name' => settings('merchant_name'),
            'slogan' => settings('merchant_slogan'),
            'phone' => settings('merchant_phone'),
            'email' => settings('merchant_email'),
            'address' => settings('merchant_address'),
            'city' => settings('merchant_city_id') ? \App\Models\City::find(settings('merchant_city_id'))?->name : null,
            'province' => settings('merchant_province_id') ? \App\Models\Province::find(settings('merchant_province_id'))?->name : null,
            'latitude' => settings('merchant_latitude'),
            'longitude' => settings('merchant_longitude'),
            'status' => settings('merchant_status'),
            'logo' => settings('merchant_logo'),
            'type' => settings('merchant_type'),
            'cnop' => settings('merchant_cnop'),
            'created_at' => settings('created_at'),
        ];
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.merchant.show');
    }
}


