<?php

namespace App\Livewire\StockEntries;

use App\Models\StockEntry;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.dashboard')]
class Show extends Component
{
    public StockEntry $stockEntry;

    public function mount(StockEntry $stockEntry): void
    {
        $this->stockEntry = $stockEntry->load(['product', 'supplier', 'purchaseOrder', 'user']);
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.stock-entries.show');
    }
}
