<?php

namespace App\Livewire\Utils;

use Livewire\Component;
use Livewire\Attributes\On;

class IsOnline extends Component
{
    public $isOnline = true;

    #[On('connection-status')]
    public function updateConnectionStatus(bool $online)
    {
        $this->isOnline = $online;
    }

    public function render()
    {
        return view('livewire.utils.is-online');
    }
}
