<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

/**
 * Category model
 * 
 * This model represents the categories in the application.
 * It is used to store the categories and their associated data.
 */
class Category extends Model
{
    use \Illuminate\Database\Eloquent\SoftDeletes;
    const CATEGORIES = [
        ['name' => 'Antibiotique', 'slug' => 'antibiotique', 'description' => 'Médicaments pour traiter les infections bactériennes'],
        ['name' => 'Antalgique', 'slug' => 'antalgique', 'description' => 'Médicaments pour soulager la douleur'],
        ['name' => 'Antipyrétique', 'slug' => 'antipyretique', 'description' => 'Médicaments pour faire baisser la fièvre'],
        ['name' => 'Antipaludique', 'slug' => 'antipaludique', 'description' => 'Médicaments pour prévenir et traiter le paludisme'],
        ['name' => 'Antiseptique', 'slug' => 'antiseptique', 'description' => 'Produits pour désinfecter et nettoyer les plaies'],
        ['name' => 'Antidiabétique', 'slug' => 'antidiabetique', 'description' => 'Médicaments pour traiter le diabète'],
        ['name' => 'Antihypertenseur', 'slug' => 'antihypertenseur', 'description' => 'Médicaments pour traiter l\'hypertension'],
        ['name' => 'Antiallergique', 'slug' => 'antiallergique', 'description' => 'Médicaments pour traiter les allergies'],
        ['name' => 'Antiviral', 'slug' => 'antiviral', 'description' => 'Médicaments pour traiter les infections virales'],
        ['name' => 'Antifongique', 'slug' => 'antifongique', 'description' => 'Médicaments pour traiter les infections fongiques'],
        ['name' => 'Supplément vitaminique', 'slug' => 'supplement-vitaminique', 'description' => 'Compléments alimentaires riches en vitamines'],
        ['name' => 'Produit dermatologique', 'slug' => 'produit-dermatologique', 'description' => 'Produits pour traiter les affections de la peau'],
        ['name' => 'Produit ophtalmique', 'slug' => 'produit-ophtalmique', 'description' => 'Produits pour traiter les affections des yeux'],
        ['name' => 'Produit ORL', 'slug' => 'produit-orl', 'description' => 'Produits pour traiter les affections ORL'],
        ['name' => 'Produit gynécologique', 'slug' => 'produit-gynecologique', 'description' => 'Produits pour traiter les affections gynécologiques'],
        ['name' => 'Anti-inflammatoire', 'slug' => 'anti-inflammatoire', 'description' => 'Médicaments pour réduire l\'inflammation'],
        ['name' => 'Antispasmodique', 'slug' => 'antispasmodique', 'description' => 'Médicaments pour soulager les spasmes'],
        ['name' => 'Antitussif', 'slug' => 'antitussif', 'description' => 'Médicaments pour calmer la toux'],
    ];


    protected $guarded = [];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public static function generateUniqueSlug()
    {
        $slug = Str::orderedUuid();
        $count = self::where('slug', 'like', "{$slug}%")->count();
        if ($count > 0) {
            $slug .= '-' . ($count + 1);
        }

        return $slug;
    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }
}
