<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    protected $guarded = [];

    public $timestamps = false;

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function province()
    {
        return $this->belongsTo(Province::class);
    }

    public static function getIdBySlug($citySlug)
    {
        if ($city = City::where('slug', $citySlug)->first()) {
            return $city->id;
        }

        return null;
    }

    const DEFAULT_CITIES = [
        ['name' => 'Kinshasa', 'slug' => 'kinshasa', 'province_id' => 1],

        // 2
        ['name' => 'Boma', 'slug' => 'boma', 'province_id' => 2],
        ['name' => 'Matadi', 'slug' => 'matadi', 'province_id' => 2],

        // 3
        ['name' => 'Kenge', 'slug' => 'kenge', 'province_id' => 3],

        // 4. KWANGO
        ['name' => 'Bandundu', 'slug' => 'bandundu', 'province_id' => 3],
        ['name' => 'Kikwit', 'slug' => 'kikwit', 'province_id' => 3],

        // 5. Mai-Ndombe
        ['name' => 'Inongo', 'slug' => 'inongo', 'province_id' => 5],

        // 6. Kasai
        ['name' => 'Tshikapa', 'slug' => 'tshikapa', 'province_id' => 6],

        // 7. Kasai-Central
        ['name' => 'Kananga', 'slug' => 'kananga', 'province_id' => 7],

        // 8. Kasai-Central
        ['name' => 'Mbuji-Mayi', 'slug' => 'mbuji-mayi', 'province_id' => 8],

        // 9. Lomami
        ['name' => 'Kabinda', 'slug' => 'kabinda', 'province_id' => 9],
        ['name' => 'Mwene-Ditu', 'slug' => 'mwene-ditu', 'province_id' => 9],

        // 10. Sankuru

        ['name' => 'Lusambo', 'slug' => 'lusambo', 'province_id' => 10],

        // 11.
        ['name' => 'Kindu', 'slug' => 'kindu', 'province_id' => 11],

        // 12
        ['name' => 'Baraka', 'slug' => 'baraka', 'province_id' => 12],
        ['name' => 'Uvira', 'slug' => 'uvira', 'province_id' => 12],
        ['name' => 'Bukavu', 'slug' => 'bukavu', 'province_id' => 12],

        // 13
        ['name' => 'Goma', 'slug' => 'goma', 'province_id' => 13],
        ['name' => 'Butembo', 'slug' => 'butembo', 'province_id' => 13],
        ['name' => 'Beni', 'slug' => 'beni', 'province_id' => 13],

        // 14
        ['name' => 'Bunia', 'slug' => 'bunia', 'province_id' => 14],

        // 15
        ['name' => 'Isiro', 'slug' => 'isiro', 'province_id' => 15],

        // 16
        ['name' => 'Kisangani', 'slug' => 'kisangani', 'province_id' => 16],

        // 17
        ['name' => 'Buta', 'slug' => 'buta', 'province_id' => 17],

        // 18
        ['name' => 'Gbadolite', 'slug' => 'gbadolite', 'province_id' => 18],

        // 19
        ['name' => 'Lisala', 'slug' => 'lisala', 'province_id' => 19],

        // 20
        ['name' => 'Gemena', 'slug' => 'gemena', 'province_id' => 20],
        ['name' => 'Zongo', 'slug' => 'zongo', 'province_id' => 20],

        // 21
        ['name' => 'Mbandaka', 'slug' => 'mbandaka', 'province_id' => 21],

        // 22
        ['name' => 'Boende', 'slug' => 'boende', 'province_id' => 22],

        // 23
        ['name' => 'Kalemie', 'slug' => 'kalemie', 'province_id' => 23],
        ['name' => 'Moba', 'slug' => 'moba', 'province_id' => 23],

        // 24
        ['name' => 'Kamina', 'slug' => 'kamina', 'province_id' => 24],

        // 25
        ['name' => 'Kolwezi', 'slug' => 'kolwezi', 'province_id' => 25],

        // 26
        ['name' => 'Lubumbashi', 'slug' => 'lubumbashi', 'province_id' => 26],
        ['name' => 'Likasi', 'slug' => 'likasi', 'province_id' => 26],

    ];
}
