<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Contact extends Model
{
    protected $guarded = [];

    protected $fillable = [
        'phone',
        'email',
        'whatsapp',
        'website',
        'facebook',
        'twitter',
        'instagram',
    ];

    public function merchant()
    {
        return $this->hasOne(Merchant::class);
    }

    public function supplier()
    {
        return $this->hasOne(Supplier::class);
    }

    public function customer()
    {
        return $this->hasOne(Customer::class);
    }
}
