<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Province extends Model
{
    protected $guarded = [];

    public $timestamps = false;

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public static function getIdBySlug($provinceSlug)
    {
        if ($province = Province::where('slug', $provinceSlug)->first()) {
            return $province->id;
        }

        return null;
    }

    public function cities()
    {
        return $this->hasMany(City::class);
    }

    public function addresses()
    {
        return $this->hasMany(Address::class);
    }

    const DEFAULT_PROVINCES = [
        ['name' => 'Kinshasa', 'slug' => 'kinshasa'],
        ['name' => 'Kongo Central', 'slug' => 'kongo-central'],
        ['name' => 'Kwango', 'slug' => 'kwango'],
        ['name' => 'Kwilu', 'slug' => 'kwilu'],
        ['name' => 'Mai-Ndombe', 'slug' => 'mai-ndombe'],
        ['name' => 'Kasaï', 'slug' => 'kasai'],
        ['name' => 'Kasaï-Central', 'slug' => 'kasai-central'],
        ['name' => 'Kasaï-Oriental', 'slug' => 'kasai-oriental'],
        ['name' => 'Lomami', 'slug' => 'lomami'],
        ['name' => 'Sankuru', 'slug' => 'sankuru'],
        ['name' => 'Maniema', 'slug' => 'maniema'],
        ['name' => 'Sud-Kivu', 'slug' => 'sud-kivu'],
        ['name' => 'Nord-Kivu', 'slug' => 'nord-kivu'],
        ['name' => 'Ituri', 'slug' => 'ituri'],
        ['name' => 'Haut-Uele', 'slug' => 'haut-uele'],
        ['name' => 'Tshopo', 'slug' => 'tshopo'],
        ['name' => 'Bas-Uele', 'slug' => 'bas-uele'],
        ['name' => 'Nord-Ubangi', 'slug' => 'nord-ubangi'],
        ['name' => 'Mongala', 'slug' => 'mongala'],
        ['name' => 'Sud-Ubangi', 'slug' => 'sud-ubangi'],
        ['name' => 'Équateur', 'slug' => 'equateur'],
        ['name' => 'Tshuapa', 'slug' => 'tshuapa'],
        ['name' => 'Tanganyika', 'slug' => 'tanganyika'],
        ['name' => 'Haut-Lomami', 'slug' => 'haut-lomami'],
        ['name' => 'Lualaba', 'slug' => 'lualaba'],
        ['name' => 'Haut-Katanga', 'slug' => 'haut-katanga'],
    ];
}
