<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\CheckAppInitialized;
use App\Http\Middleware\CheckAppLicensed;
use App\Http\Middleware\PreventLicenseAccess;
use App\Http\Middleware\EnsureUserIsActive;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'app.initialized' => CheckAppInitialized::class,
            'app.licensed' => CheckAppLicensed::class,
            'prevent.license.access' => PreventLicenseAccess::class,
            'active.user' => EnsureUserIsActive::class,
        ]);

        // Apply initialization check globally so first request triggers it
        $middleware->web(append: [CheckAppInitialized::class, EnsureUserIsActive::class]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
