<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('slug')->unique();

            // Relations
            $table->foreignId('address_id')->nullable()->constrained('addresses')->nullOnDelete();

            // Identity
            $table->string('firstname');
            $table->string('lastname');
            $table->string('username')->unique();

            // Email
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();

            // Phone
            $table->string('phone')->nullable()->unique();
            $table->timestamp('phone_verified_at')->nullable();

            // Media
            $table->string('photo_path')->nullable();

            // Security
            $table->string('password');
            $table->rememberToken();
            $table->string('api_token')->nullable();
            $table->timestamp('last_login_at')->nullable();
            $table->integer('failed_login_attempts')->default(0);
            $table->timestamp('locked_until')->nullable();

            // Status
            $table->enum('role', ['owner', 'admin', 'cashier', 'stock_manager'])->default('cashier');
            $table->boolean('status')->default(true);
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('phone')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
