<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('purchase_orders', function (Blueprint $table) {
            $table->id();

            $table->foreignId('supplier_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();

            $table->string('reference')->unique(); // e.g. PO-00001
            $table->date('order_date');
            $table->date('expected_delivery_date')->nullable();

            $table->boolean('status')->default(false);
            $table->text('notes')->nullable();

            $table->timestamps();
            $table->softDeletes();

            $table->index(['reference']);
            $table->index(['supplier_id', 'status']);
            $table->index(['order_date', 'status']);
            $table->index(['status', 'order_date'], 'purchase_orders_status_date_index');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchase_orders');
    }
};
