<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('purchase_order_items', function (Blueprint $table) {
            $table->id();

            $table->foreignId('purchase_order_id')->constrained('purchase_orders')->cascadeOnDelete();
            $table->foreignId('product_id')->constrained()->cascadeOnDelete();

            $table->integer('quantity')->default(0); // Quantity ordered
            $table->string('unit', 50)->default('pièce'); // Unit of measurement
            $table->decimal('unit_price', 10, 2)->nullable(); // Price per unit at order time
            $table->decimal('total_price', 10, 2)->nullable(); // unit_price * quantity
            $table->integer('received_quantity')->default(0);

            $table->timestamps();

            $table->index(['purchase_order_id']);
            $table->index(['product_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchase_order_items');
    }
};
