<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('locations', function (Blueprint $table) {
            $table->id();

            // Relations
            $table->foreignId('address_id')->nullable()->constrained('addresses')->nullOnDelete();

            // Identity
            $table->string('name');
            $table->string('slug')->unique();

            $table->text('description')->nullable();

            // Status
            $table->tinyInteger('status')->default(0);
            $table->timestamps();

            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('locations');
    }
};
