<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('activity_logs', function (Blueprint $table) {
            $table->id();
            
            // User information
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            
            // Activity details
            $table->string('action'); // e.g., 'login', 'logout', 'create_product', 'update_sale'
            $table->string('description'); // Human-readable description
            $table->string('model_type')->nullable(); // e.g., 'App\Models\Product'
            $table->unsignedBigInteger('model_id')->nullable(); // ID of the affected model
            
            // Request information
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->string('url')->nullable();
            $table->string('method', 10)->nullable(); // GET, POST, PUT, DELETE
            
            // Additional data
            $table->json('properties')->nullable(); // Store additional data as JSON
            $table->string('severity', 20)->default('info'); // info, warning, error, critical
            
            // Location information (if available)
            $table->string('country')->nullable();
            $table->string('city')->nullable();
            
            $table->timestamps();
            
            // Indexes for better performance
            $table->index(['user_id', 'created_at']);
            $table->index(['action', 'created_at']);
            $table->index(['model_type', 'model_id']);
            $table->index('severity');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('activity_logs');
    }
};
