<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('debt_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('debt_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Who recorded the payment
            $table->decimal('amount', 15, 2); // Payment amount
            $table->date('payment_date'); // When the payment was made
            $table->enum('payment_method', ['cash', 'bank_transfer', 'mobile_money', 'other'])->default('cash');
            $table->text('notes')->nullable(); // Additional notes about the payment
            $table->string('reference')->nullable(); // Payment reference number
            $table->timestamps();

            // Indexes for better performance
            $table->index(['debt_id', 'payment_date']);
            $table->index('payment_date');
            $table->index('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('debt_payments');
    }
};