<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conversations', function (Blueprint $table) {
            $table->id();
            $table->string('slug')->unique(); // API conversation slug
            $table->string('client_slug')->nullable(); // Client identifier from API
            $table->string('client_first_name')->nullable();
            $table->string('client_last_name')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('deleted_by_user')->default(false);
            $table->boolean('deleted_by_merchant')->default(false);
            $table->timestamp('api_created_at')->nullable(); // API creation timestamp
            $table->timestamp('api_updated_at')->nullable(); // API update timestamp
            $table->timestamps();

            $table->index(['slug']);
            $table->index(['client_slug']);
            $table->index(['is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conversations');
    }
};
