<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conversation_messages', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('conversation_id');
            $table->integer('api_message_id')->nullable(); // API message ID
            $table->enum('sender_type', ['merchant', 'user']); // who sent the message
            $table->unsignedBigInteger('user_id')->nullable(); // user ID if from user
            $table->unsignedBigInteger('merchant_id')->nullable(); // merchant ID if from merchant
            $table->text('body'); // message content
            $table->timestamp('api_created_at')->nullable(); // API creation timestamp
            $table->timestamps();

            $table->foreign('conversation_id')->references('id')->on('conversations')->onDelete('cascade');
            $table->index(['conversation_id']);
            $table->index(['api_message_id']);
            $table->index(['sender_type']);
            $table->index(['api_created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conversation_messages');
    }
};
