<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('stock_adjustments', function (Blueprint $table) {
            $table->timestamp('applied_at')->nullable()->after('status');
            $table->unsignedBigInteger('applied_by')->nullable()->after('applied_at');

            $table->foreign('applied_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('stock_adjustments', function (Blueprint $table) {
            $table->dropForeign(['applied_by']);
            $table->dropColumn(['applied_at', 'applied_by']);
        });
    }
};
