@props([
'title' => '',
'items' => [], // ['Dashboard' => '/dashboard', 'Technician' => null]
])

<x-basics.card>
    <div class="container mx-auto px-4">
        <div class="md:flex md:items-center md:justify-between">
            <div class="flex-1 min-w-0">
                <h1 class="text-2xl font-bold text-gray-900">
                    {!! $title !!}
                </h1>
                <div class="mt-4 flex md:mt-0">
                    <nav class="text-sm text-gray-600" aria-label="Breadcrumb">
                        <ol class="flex items-center">
                            @foreach ($items as $label => $url)
                            <li class="flex items-center">
                                @if (!$loop->first)
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                </svg>
                                @endif
                                
                                @if ($url)
                                <a href="{{ $url }}" class="inline-flex items-center {{ $loop->first ? 'pe-3' : 'px-3' }} py-1.5 text-indigo-600 hover:text-indigo-800 font-medium transition">
                                    {{ Str::limit($label, 35) }}
                                </a>
                                @else
                                <span class="inline-flex items-center px-3 py-1.5 text-gray-700 font-medium transition">
                                    {!! $label !!}
                                </span>
                                @endif
                            </li>
                            @endforeach
                        </ol>
                    </nav>
                </div>
            </div>
            <!-- Named slot "action" for header actions -->
            @isset($action)
            {{ $action }}
            @endisset
        </div>
    </div>
</x-basics.card>