@props(['user'])

<div class="space-y-6">
    <!-- User Status -->
    <x-basics.card title="Statut du Compte" subtitle="Informations sur votre compte">
        <div class="space-y-3">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut:</span>
                {!! $user->status_badge !!}
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Rôle:</span>
                {!! $user->role_badge !!}
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Membre depuis:</span>
                <span class="text-sm font-medium">{{ $user->created_at->format('d/m/Y') }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Dernière connexion:</span>
                <span class="text-sm font-medium">
                    {{ $user->last_login_at ? $user->last_login_at->format('d/m/Y H:i') : 'Jamais' }}
                </span>
            </div>
        </div>
    </x-basics.card>


    <!-- Tips -->
    <x-basics.card title="Conseils de Sécurité" bodyBg="bg-yellow-50">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start space-x-2">
                <i class="ph ph-lightbulb text-yellow-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Utilisez un mot de passe fort</strong> avec au moins 8 caractères.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-shield-check text-green-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Ne partagez jamais</strong> vos identifiants de connexion.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-warning text-orange-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Déconnectez-vous</strong> toujours après utilisation sur un ordinateur partagé.
                </p>
            </div>
        </div>
    </x-basics.card>
</div>
