@props(['category'])

<div class="space-y-6">

    <x-basics.card title="Statistiques" subtitle="Informations sur la catégorie">
        <div class="space-y-3">

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Total des produits:</span>
                <span class="text-sm font-medium">{{ $category->products->count() }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Créée le:</span>
                <span class="text-sm font-medium">{{ $category->created_at->format('d/m/Y') }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Modifiée le:</span>
                <span class="text-sm font-medium">{{ $category->updated_at->format('d/m/Y') }}</span>
            </div>

        </div>
    </x-basics.card>

    <!-- Essentials (grouped) -->
    <x-basics.card title="Conseils Catégorie" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start space-x-2">
                <i class="ph ph-folder text-blue-600 mt-0.5"></i>
                <p class="text-gray-600">
                    Les catégories structurent vos produits et simplifient la recherche.
                </p>
            </div>
            <div class="flex items-start space-x-2">
                <i class="ph ph-lightbulb text-green-600 mt-0.5"></i>
                <p class="text-gray-600">
                    Noms clairs et cohérents (ex: « Antibiotiques », « Soins bébé »). Limitez la hiérarchie.
                </p>
            </div>
            <div class="flex items-start space-x-2">
                <i class="ph ph-warning text-orange-600 mt-0.5"></i>
                <p class="text-gray-600">
                    La suppression d’une catégorie impacte tous les produits associés. Vérifiez avant d’agir.
                </p>
            </div>
        </div>
    </x-basics.card>
</div>
