@props([
    'title',
    'subtitle' => null,
    'chartType' => 'bar'
])

<div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
    <div class="flex items-center justify-between mb-6">
        <div>
            <h3 class="text-lg font-semibold text-gray-900">{{ $title }}</h3>
            @if($subtitle)
                <p class="text-sm text-gray-600">{{ $subtitle }}</p>
            @endif
        </div>
        @if($chartType === 'bar')
            <select class="text-sm border border-gray-300 rounded-md px-3 py-1">
                <option>Last 12 Months</option>
                <option>Last 6 Months</option>
                <option>Last 3 Months</option>
            </select>
        @endif
    </div>
    <div class="chart-container">
        {{ $slot }}
    </div>
</div> 