@props(['customer'])

<div x-data="{ showActivateModal: false, showDeactivateModal: false, showDeleteModal: false }">

    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            @if ($customer->status === App\Models\Customer::STATUS_ACTIVE)
                <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('customers.show', $customer) }}" wire:navigate>
                    Voir les détails
                </x-basics.dropdown-item>
            @endif

            <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('customers.edit', $customer) }}" wire:navigate>
                Modifier
            </x-basics.dropdown-item>

            @if ($customer->status === App\Models\Customer::STATUS_ACTIVE)
                <x-basics.dropdown-separator />

                <x-basics.dropdown-item icon="ph ph-receipt" href="{{ route('customers.sales.index', $customer) }}">
                    Voir toutes les ventes
                </x-basics.dropdown-item>

                <x-basics.dropdown-item icon="ph ph-credit-card" href="{{ route('customers.debts.index', $customer) }}">
                    Voir toutes les dettes
                </x-basics.dropdown-item>
            @endif



            @if ($customer->status === App\Models\Customer::STATUS_ACTIVE)
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-pause-circle" variant="warning" @click="showDeactivateModal = true">
                    Désactiver
                </x-basics.dropdown-item>
            @else
                <x-basics.dropdown-item icon="ph ph-play-circle" variant="success" @click="showActivateModal = true">
                    Activer
                </x-basics.dropdown-item>
            @endif

            @if ($customer->sales->count() === 0)
                <x-basics.dropdown-separator />

                <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                    Supprimer
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    @if ($customer->status == \App\Models\Customer::STATUS_INACTIVE)
        <!-- Activation Modal -->
        <x-basics.modal show="showActivateModal" title="Activer le client"
            description="Confirmer l'activation du client">
            <p>Voulez-vous vraiment activer ce client ?</p>
            <p class="text-sm text-gray-600 mt-2">
                Le client sera disponible pour les ventes et les opérations de stock.
            </p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <form method="POST" action="{{ route('customers.activate', $customer) }}" class="inline w-full">
                        @csrf
                        <x-basics.button type="submit" variant="success" class="w-full">
                            <i class="ph ph-play-circle mr-2"></i>
                            Activer
                        </x-basics.button>
                    </form>
                </div>
            @endslot
        </x-basics.modal>
    @endif

    @if ($customer->status == \App\Models\Customer::STATUS_ACTIVE)
        <!-- Deactivation Modal -->
        <x-basics.modal show="showDeactivateModal" title="Désactiver le client"
            description="Confirmer la désactivation du client">
            <p>Voulez-vous vraiment désactiver ce client ?</p>
            <p class="text-sm text-gray-600 mt-2">
                Le client ne sera plus disponible pour les nouvelles ventes, mais les ventes existantes resteront
                intactes.
            </p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <form method="POST" action="{{ route('customers.deactivate', $customer) }}" class="inline w-full">
                        @csrf
                        <x-basics.button type="submit" variant="warning" class="w-full">
                            <i class="ph ph-pause-circle mr-2"></i>
                            Désactiver
                        </x-basics.button>
                    </form>
                </div>
            @endslot
        </x-basics.modal>
    @endif



    @if ($customer->sales->count() === 0)
        <form action="{{ route('customers.destroy', $customer) }}" method="POST">
            @csrf
            @method('DELETE')

            <x-basics.modal show="showDeleteModal" title="Supprimer le client" description="">
                <p>Voulez-vous vraiment supprimer ce client ?</p>
                <p class="text-sm text-red-500">Cette action est irréversible.</p>

                <div class="mt-3 text-gray-600 text-sm">
                    <p>En supprimant ce client :</p>
                    <ul class="list-disc list-inside mt-1">
                        <li>Toutes les informations du client seront supprimées</li>
                        <li>Les coordonnées et l'adresse seront supprimées</li>
                        <li>Cette action ne peut pas être annulée</li>
                    </ul>
                </div>

                @slot('footer')
                    <x-basics.button type="submit" variant="danger" class="w-full">
                        Supprimer le client
                    </x-basics.button>
                @endslot
            </x-basics.modal>
        </form>
    @endif

</div>
