@props(['debt'])

<div x-data="{ showPaymentModal: false }">
    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('debts.show', $debt) }}">
                Voir les détails
            </x-basics.dropdown-item>

            @if ($debt->status !== \App\Models\Debt::STATUS_PAID)
                <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('debts.edit', $debt) }}">
                    Modifier
                </x-basics.dropdown-item>

                <x-basics.dropdown-separator />

                <x-basics.dropdown-item icon="ph ph-plus" @click="showPaymentModal = true">
                    Enregistrer un paiement
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    @if ($debt->status !== \App\Models\Debt::STATUS_PAID)
        <form action="{{ route('debts.add-payment', $debt) }}" method="POST">
            @csrf

            <x-basics.modal show="showPaymentModal" title="Enregistrer un paiement"
                description="Ajouter un nouveau paiement pour cette dette" size="2xl">

                <!-- Payment Form -->
                <div class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <x-basics.input name="amount" label="Montant du paiement" type="number" step="0.01" min="0.01" max="{{ $debt->remaining_amount }}" value="{{ $debt->remaining_amount }}" placeholder="0.00" required class="mb-0" />
                        @php
                            $payment_methods = [
                                ['id' => 'cash', 'name' => 'Espèces'],
                                ['id' => 'bank_transfer', 'name' => 'Virement bancaire'],
                                ['id' => 'mobile_money', 'name' => 'Mobile Money'],
                                ['id' => 'other', 'name' => 'Autre'],
                            ];
                        @endphp
                        <x-basics.select name="payment_method" label="Méthode de paiement" optionLabel="name" displayLabel="name" :options="$payment_methods" error="{{ $errors->first('payment_method') }}" required class="mb-0"
                            mb="mb-0" />
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <x-basics.input name="payment_date" label="Date du paiement" type="date"
                            value="{{ now()->format('Y-m-d') }}" max="{{ now()->format('Y-m-d') }}" required class="mb-0" />

                        <x-basics.input name="reference" label="Référence du paiement"
                            placeholder="Ex: REF-001, Chèque N°123..." maxlength="255" class="mb-0" />
                    </div>

                    <div>
                        <x-basics.textarea name="notes" label="Notes" rows="3"
                            placeholder="Notes supplémentaires sur ce paiement..." maxlength="1000" class="mb-0" />
                    </div>
                </div>

                @slot('footer')
                    <x-basics.button type="submit" class="w-full">
                        <i class="ph ph-check mr-2"></i>
                        Enregistrer le paiement
                    </x-basics.button>
                @endslot
            </x-basics.modal>
        </form>
    @endif
</div>
