@props(['expenseCategory'])

<div x-data="{ showActivateModal: false, showDeactivateModal: false, showDeleteModal: false }">
    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye"
                href="{{ route('expense-categories.show', $expenseCategory) }}">
                Voir
            </x-basics.dropdown-item>

            <x-basics.dropdown-item icon="ph ph-pencil"
                href="{{ route('expense-categories.edit', $expenseCategory) }}">
                Modifier
            </x-basics.dropdown-item>

            @if($expenseCategory->status == \App\Models\ExpenseCategory::STATUS_ACTIVE)
                <x-basics.dropdown-item icon="ph ph-pause-circle" variant="warning"
                    @click="showDeactivateModal = true">
                    Désactiver
                </x-basics.dropdown-item>
            @else
                <x-basics.dropdown-item icon="ph ph-play-circle" variant="success"
                    @click="showActivateModal = true">
                    Activer
                </x-basics.dropdown-item>
            @endif

            @if($expenseCategory->status == \App\Models\ExpenseCategory::STATUS_ACTIVE)
            <x-basics.dropdown-separator />

            <x-basics.dropdown-item icon="ph ph-receipt" href="{{ route('expenses.index') }}">
                Voir les dépenses
            </x-basics.dropdown-item>

            <x-basics.dropdown-item icon="ph ph-plus" href="{{ route('expenses.index') }}">
                Nouvelle dépense
            </x-basics.dropdown-item>
            @endif

            <x-basics.dropdown-item icon="ph ph-folders" href="{{ route('expense-categories.index') }}">
                Voir les catégories
            </x-basics.dropdown-item>
            
            @if($expenseCategory->status == \App\Models\ExpenseCategory::STATUS_INACTIVE && $expenseCategory->expenses_count === 0)
            <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                    Supprimer
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    @if($expenseCategory->status == \App\Models\ExpenseCategory::STATUS_INACTIVE)
    <!-- Activate Category Modal -->
    <form action="{{ route('expense-categories.activate', $expenseCategory) }}" method="POST">
        @csrf
        @method('PUT')
        <x-basics.modal show="showActivateModal" title="Activer la catégorie">
            <p class="text-gray-600">
                Êtes-vous sûr de vouloir activer cette catégorie ?
                La catégorie <strong>{{ $expenseCategory->name }}</strong> sera activée et sera disponible pour les dépenses.
            </p>
            @slot('footer')
                <div class="flex justify-end gap-3 w-full">
                    <x-basics.button type="submit" variant="success" class="w-full">
                        Activer la catégorie
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>
    @endif

    @if($expenseCategory->status == \App\Models\ExpenseCategory::STATUS_ACTIVE)
    <!-- Deactivate Category Modal -->
    <form action="{{ route('expense-categories.deactivate', $expenseCategory) }}" method="POST">
        @csrf
        @method('PUT')
        <x-basics.modal show="showDeactivateModal" title="Désactiver la catégorie">
            <p class="text-gray-600">
                Êtes-vous sûr de vouloir désactiver cette catégorie ?
                La catégorie <strong>{{ $expenseCategory->name }}</strong> sera désactivée et ne sera plus disponible pour les dépenses.
            </p>
            @slot('footer')
                <div class="flex justify-end gap-3 w-full">
                    <x-basics.button type="submit" variant="warning" class="w-full">
                        Désactiver la catégorie
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>
    @endif

    @if($expenseCategory->status == \App\Models\ExpenseCategory::STATUS_INACTIVE && $expenseCategory->expenses_count === 0)
    <!-- Delete Category Modal -->
    <form action="{{ route('expense-categories.destroy', $expenseCategory) }}" method="POST">
        @csrf
        @method('DELETE')
        <x-basics.modal show="showDeleteModal" title="Supprimer la catégorie">
            <div class="text-gray-600">
                Êtes-vous sûr de vouloir supprimer cette catégorie ?
                <p class="mb-2">
                    La catégorie <strong>{{ $expenseCategory->name }}</strong> sera supprimée définitivement.
                </p>
                <p class="text-sm text-red-600">
                    Cette action est irréversible.
                </p>
            </div>
            @slot('footer')
                <div class="flex justify-end gap-3 w-full">
                    <x-basics.button type="submit" variant="danger" class="w-full">
                        Supprimer la catégorie
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>
    @endif
</div>