@props(['expense'])

<div x-data="{ showApproveModal: false, showRejectModal: false, showMarkPaidModal: false, showDeleteModal: false }">
    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('expenses.show', $expense) }}">
                Voir
            </x-basics.dropdown-item>

            @if ($expense->isDraft())
                <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('expenses.edit', $expense) }}">
                    Modifier
                </x-basics.dropdown-item>
            @endif

            @if ($expense->isDraft())
                <x-basics.dropdown-item icon="ph ph-check-circle" variant="success" @click="showApproveModal = true">
                    Approuver
                </x-basics.dropdown-item>
            @endif

            @if ($expense->user)
                <x-basics.dropdown-item icon="ph ph-user" href="{{ route('users.show', $expense->user) }}">
                    Voir l'utilisateur
                </x-basics.dropdown-item>
            @endif

            @if ($expense->isDraft())
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                    Supprimer
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    @if ($expense->isDraft())
        <!-- Approve Expense Modal -->
        <form action="{{ route('expenses.approve', $expense) }}" method="POST" class="inline">
            @csrf
            @method('PUT')
            <x-basics.modal show="showApproveModal" title="Approuver la dépense">
                <p class="text-gray-600">
                    Êtes-vous sûr de vouloir approuver cette dépense ?
                    La dépense <strong>{{ $expense->title }}</strong> sera approuvée et permettra de la marquer comme
                    payée.
                </p>
                @slot('footer')
                    <div class="flex justify-end gap-3 w-full">
                        <x-basics.button type="submit" class="w-full" variant="success">
                            Approuver
                        </x-basics.button>
                    </div>
                @endslot
            </x-basics.modal>
        </form>
    @endif


    @if ($expense->isApproved())
        <!-- Mark as Paid Modal -->
        <form action="{{ route('expenses.mark-paid', $expense) }}" method="POST" class="inline">
            @csrf
            @method('PUT')
            <x-basics.modal show="showMarkPaidModal" title="Marquer comme payée">
                <p class="text-gray-600">
                    Êtes-vous sûr de vouloir marquer cette dépense comme payée ?
                    La dépense <strong>{{ $expense->title }}</strong> sera marquée comme payée et finalisera le
                    processus.
                </p>
                @slot('footer')
                    <div class="flex justify-end gap-3 w-full">
                        <x-basics.button type="submit" class="w-full" variant="success">
                            Marquer comme payée
                        </x-basics.button>
                    </div>
                @endslot
            </x-basics.modal>
        </form>
    @endif


    @if ($expense->isDraft())
        <!-- Delete Confirmation Modal -->
        <form action="{{ route('expenses.destroy', $expense) }}" method="POST" class="inline">
            @csrf
            @method('DELETE')
            <x-basics.modal show="showDeleteModal" title="Confirmer la suppression">
                <div class="text-gray-600">
                    Êtes-vous sûr de vouloir supprimer cette dépense ?
                    <p class="mb-2">
                        La dépense <strong>{{ $expense->title }}</strong> sera supprimée définitivement.
                    </p>
                    <p class="text-sm text-red-600">
                        Cette action est irréversible.
                    </p>
                </div>
                @slot('footer')
                    <div class="flex justify-end gap-3 w-full">
                        <x-basics.button type="submit" class="bg-red-600 hover:bg-red-700 text-white w-full">
                            Supprimer
                        </x-basics.button>
                    </div>
                @endslot
            </x-basics.modal>
        </form>
    @endif
</div>
