@props(['expense'])

<div class="space-y-6" x-data="{ showDeleteModal: false, showApproveModal: false, showRejectModal: false, showMarkPaidModal: false }">

    @isset($expense)
    <!-- Status Card -->
    <x-basics.card title="Statut" subtitle="Informations sur la dépense">
        
        <div class="space-y-3">
            <div class="flex items-center justify-between">
                <span class="text-sm font-medium text-gray-700">Statut:</span>
                <div>{!! $expense->status_badge !!}</div>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm font-medium text-gray-700">Date de dépense:</span>
                <span class="text-sm text-gray-900">{{ $expense->formatted_date }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm font-medium text-gray-700">Créé le:</span>
                <span class="text-sm text-gray-900">{{ $expense->created_at->format('d/m/Y H:i') }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm font-medium text-gray-700">Modifié le:</span>
                <span class="text-sm text-gray-900">{{ $expense->updated_at->format('d/m/Y H:i') }}</span>
            </div>
        </div>

    </x-basics.card>

    @endisset
    
    <!-- Expense Management -->
    <x-basics.card title="Gestion des Dépenses" bodyBg="bg-orange-50">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start space-x-2">
                <i class="ph ph-receipt text-orange-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Suivi des coûts :</strong> Enregistrez toutes les dépenses pour un contrôle budgétaire précis.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-folder text-blue-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Catégorisation :</strong> Utilisez les catégories pour organiser et analyser vos dépenses.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-chart-line text-green-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Analyse financière :</strong> Consultez les rapports pour suivre l'évolution de vos coûts.
                </p>
            </div>
            
        </div>
    </x-basics.card>
</div>
