@props(['location'])

<x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
    <x-slot name="trigger">
        <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
            <i class="ph ph-dots-three-outline-vertical text-xl"></i>
        </button>
    </x-slot>

    <x-slot name="content">
        <x-basics.dropdown-item icon="ph ph-eye"
            href="{{ route('locations.show', $location) }}">
            Voir
        </x-basics.dropdown-item>

        <x-basics.dropdown-item icon="ph ph-pencil"
            href="{{ route('locations.edit', $location) }}">
            Modifier
        </x-basics.dropdown-item>

        @if ($location->status === 0)
            <x-basics.dropdown-item icon="ph ph-check-circle" @click="showActivateModal = true" variant="success">
                Activer
            </x-basics.dropdown-item>
        @else
            <x-basics.dropdown-item icon="ph ph-x-circle" @click="showDeactivateModal = true" variant="danger">
                Désactiver
            </x-basics.dropdown-item>
        @endif

        <x-basics.dropdown-separator />

        <x-basics.dropdown-item icon="ph ph-package"
            href="{{ route('products.index') }}?location_id={{ $location->id }}">
            Voir les produits
        </x-basics.dropdown-item>

        <x-basics.dropdown-separator />

        <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
            Supprimer
        </x-basics.dropdown-item>
    </x-slot>
</x-basics.dropdown>
