@props([
    'merchant' => null,
    'showActions' => true,
])

@if($merchant)
    <x-basics.card class="min-h-[100%] hover:shadow-md transition-shadow duration-300">
        <x-slot name="action">
            {!! $merchant->getStatusBadge() !!}
        </x-slot>

        <div class="space-y-3">
            <!-- Merchant Header -->
            <div class="flex items-center space-x-3">
                <!-- Logo/Image Placeholder -->
                <div class="flex-shrink-0">
                    <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center">
                        <i class="ph ph-storefront text-white text-lg"></i>
                    </div>
                </div>

                <!-- Merchant Info -->
                <div class="flex-1 min-w-0">
                    <h3 class="text-base font-semibold text-gray-900 truncate">
                        {{ $merchant->name }}
                    </h3>
                    <p class="text-xs text-gray-500 mt-1 truncate">
                        <i class="ph ph-map-pin mr-1"></i>
                        {{ $merchant->address->city->name ?? 'N/A' }}
                    </p>
                    @if($merchant->merchantType)
                        <div class="mt-1">
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                {{ $merchant->merchantType->name }}
                            </span>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="flex justify-between text-xs text-gray-600 border-t border-gray-100 pt-2">
                <span>
                    <i class="ph ph-package mr-1"></i>
                    {{ $merchant->products()->count() }} produits
                </span>
                <span>
                    <i class="ph ph-shopping-cart mr-1"></i>
                    {{ $merchant->sales()->count() }} ventes
                </span>
            </div>

            <!-- Actions -->
            @if($showActions)
                <div class="flex space-x-2 pt-2">
                    <x-basics.button-link 
                        href="{{ route('dashboard.merchants.show', $merchant) }}" 
                        class="flex-1 bg-blue-600 hover:bg-blue-700 text-white text-xs py-1"
                        leftIcon="ph-eye"
                    >
                        Voir
                    </x-basics.button-link>
                    
                    @if($merchant->status == \App\Models\Merchant::STATUS_DRAFT)
                        <x-basics.button-link 
                            href="{{ route('dashboard.merchants.step1', $merchant) }}" 
                            class="flex-1 bg-gray-600 hover:bg-gray-700 text-white text-xs py-1"
                            leftIcon="ph-pencil"
                        >
                            Modifier
                        </x-basics.button-link>
                    @endif
                </div>
            @endif
        </div>
    </x-basics.card>
@else
    <x-basics.card class="min-h-[100%]">
        <div class="text-center py-6">
            <i class="ph ph-storefront text-3xl text-gray-300 mb-2"></i>
            <p class="text-gray-500 text-sm">Aucun établissement</p>
        </div>
    </x-basics.card>
@endif 