@props(['paymentMethod'])

<div class="space-y-6">
    <x-basics.card title="Informations" subtitle="Détails de la méthode">
        <div class="space-y-3">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut:</span>
                {!! $paymentMethod->status_badge !!}
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Créé le:</span>
                <span class="text-sm font-medium text-gray-900">{{ $paymentMethod->created_at->format('d/m/Y') }}</span>
            </div>
        </div>
    </x-basics.card>

    <x-basics.card title="Conseils" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start space-x-2">
                <i class="ph ph-lightbulb text-blue-600 mt-0.5"></i>
                <p class="text-gray-600">
                    Activez uniquement les méthodes réellement utilisées par votre commerce.
                </p>
            </div>
            <div class="flex items-start space-x-2">
                <i class="ph ph-check-circle text-green-600 mt-0.5"></i>
                <p class="text-gray-600">
                    Vous pouvez désactiver une méthode temporairement sans la supprimer.
                </p>
            </div>
            <div class="flex items-start space-x-2">
                <i class="ph ph-warning text-orange-600 mt-0.5"></i>
                <p class="text-gray-600">
                    La suppression est définitive et enlève la méthode de la liste.
                </p>
            </div>
        </div>
    </x-basics.card>
</div>


