@props(['prescription', 'isOnline' => true])

<div x-data="{ showCancelModal: false, showFinishModal: false, showApproveModal: false }">

    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>



        <x-slot name="content">
            @if ($prescription->status === 'En attente')
                @if ($isOnline)
                    <x-basics.dropdown-item icon="ph ph-check-circle" variant="success" type="button"
                        @click="showApproveModal = true">
                        Approuver
                    </x-basics.dropdown-item>

                    <x-basics.dropdown-separator />

                    <x-basics.dropdown-item icon="ph ph-x-circle" variant="danger" type="button"
                        @click="showCancelModal = true">
                        Annuler
                    </x-basics.dropdown-item>
                @else
                    <div class="px-4 py-2 text-sm text-gray-500">
                        <i class="ph ph-wifi-slash mr-3"></i>
                        Actions non disponibles hors ligne
                    </div>
                @endif
            @endif

            @if ($prescription->status === 'Approuvé')
                <x-basics.dropdown-item icon="ph ph-chat-circle"
                    href="{{ $prescription->conversation_slug ? route('conversations.show', $prescription->conversation_slug) : '#' }}">
                    Contacter le client
                </x-basics.dropdown-item>

                @if ($isOnline)
                    <x-basics.dropdown-item icon="ph ph-check-circle" variant="success" @click="showFinishModal = true">
                        Marquer comme terminé
                    </x-basics.dropdown-item>
                @else
                    <div class="px-4 py-2 text-sm text-gray-500">
                        <i class="ph ph-wifi-slash mr-3"></i>
                        Action non disponible hors ligne
                    </div>
                @endif
            @endif

            @if ($prescription->status === 'Terminé')
                <div class="px-4 py-2 text-sm text-gray-500">
                    <i class="ph ph-check-circle mr-3"></i>
                    Prescription terminée
                </div>
            @endif

            @if ($prescription->status === 'Annulé')
                <div class="px-4 py-2 text-sm text-gray-500">
                    <i class="ph ph-x-circle mr-3"></i>
                    Prescription annulée
                </div>
            @endif
        </x-slot>
    </x-basics.dropdown>

    <!-- Approve Modal -->
    @if ($prescription->status === 'En attente')
        <form action="{{ route('prescriptions.approve', $prescription->reference) }}" method="POST">
            @csrf

            <x-basics.modal show="showApproveModal" title="Approuver la prescription" description="">
                <p>Voulez-vous vraiment approuver cette prescription ?</p>
                
                <div class="mt-3 text-gray-600 text-sm">
                    <p>En approuvant cette prescription :</p>
                    <ul class="list-disc list-inside mt-1">
                        <li>La prescription sera marquée comme approuvée.</li>
                        <li>Le client sera notifié de l'approbation.</li>
                        <li>Vous pourrez ensuite contacter le client ou marquer comme terminé.</li>
                    </ul>
                </div>

                @slot('footer')
                    <x-basics.button type="submit" variant="success" class="w-full">
                        Approuver la prescription
                    </x-basics.button>
                @endslot
            </x-basics.modal>
        </form>
    @endif

    <!-- Cancel Modal -->
    @if ($prescription->status === 'En attente')
        <form action="{{ route('prescriptions.cancel', $prescription->reference) }}" method="POST">
            @csrf

            <x-basics.modal show="showCancelModal" title="Annuler la prescription" description="">
                <p>Voulez-vous vraiment annuler cette prescription ?</p>
                <p class="text-sm text-red-500">Cette action est irréversible.</p>

                <div class="mt-3 text-gray-600 text-sm">
                    <p>En annulant cette prescription :</p>
                    <ul class="list-disc list-inside mt-1">
                        <li>La prescription sera marquée comme annulée.</li>
                        <li>Le client sera notifié de l'annulation.</li>
                    </ul>
                </div>

                @slot('footer')
                    <x-basics.button type="submit" variant="danger" class="w-full">
                        Annuler la prescription
                    </x-basics.button>
                @endslot
            </x-basics.modal>
        </form>
    @endif

    <!-- Finish Modal -->
    @if ($prescription->status === 'Approuvé')
        <form action="{{ route('prescriptions.finish', $prescription->reference) }}" method="POST">
            @csrf

            <x-basics.modal show="showFinishModal" title="Marquer comme terminé" description="">
                <p>Voulez-vous marquer cette prescription comme terminée ?</p>

                <div class="mt-3 text-gray-600 text-sm">
                    <p>En marquant comme terminé :</p>
                    <ul class="list-disc list-inside mt-1">
                        <li>La prescription sera marquée comme terminée.</li>
                        <li>Le client sera notifié de la finalisation.</li>
                    </ul>
                </div>

                @slot('footer')
                    <x-basics.button type="submit" variant="success" class="w-full">
                        Marquer comme terminé
                    </x-basics.button>
                @endslot
            </x-basics.modal>
        </form>
    @endif

</div>

