@props(['purchaseOrder'])

<div x-data="{ showDeleteModal: false, showActivateModal: false, showReceiveModal: false, showCancelModal: false, showReactivateModal: false }">
    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('purchase-orders.show', $purchaseOrder) }}">
                Voir
            </x-basics.dropdown-item>

            @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_DRAFT)
                <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('purchase-orders.edit', $purchaseOrder) }}">
                    Modifier
                </x-basics.dropdown-item>
            @endif

            @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_ACTIVE)
                @if (!Route::is('purchase-orders.receive-form'))
                    <x-basics.dropdown-item icon="ph ph-check-circle" variant="success" @click="showReceiveModal = true">
                        Recevoir la commande
                    </x-basics.dropdown-item>
                @endif

                <x-basics.dropdown-item icon="ph ph-x-circle" variant="danger" @click="showCancelModal = true">
                    Annuler la commande
                </x-basics.dropdown-item>

                <x-basics.dropdown-item icon="ph ph-printer" href="{{ route('purchase-orders.print', $purchaseOrder) }}"
                    target="_blank">
                    Imprimer la commande
                </x-basics.dropdown-item>
            @endif


            @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_DRAFT)
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-paper-plane" variant="primary" @click="showActivateModal = true">
                    Lancer la commande
                </x-basics.dropdown-item>

                <x-basics.dropdown-item icon="ph ph-x-circle" variant="danger" @click="showCancelModal = true">
                    Annuler
                </x-basics.dropdown-item>
            @endif

            @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_CANCELLED)
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-arrow-clockwise" variant="primary"
                    @click="showReactivateModal = true">
                    Réactiver
                </x-basics.dropdown-item>
            @endif

            @if (
                $purchaseOrder->status === App\Models\PurchaseOrder::STATUS_DRAFT ||
                    $purchaseOrder->status === App\Models\PurchaseOrder::STATUS_CANCELLED)
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                    Supprimer
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>


    @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_DRAFT)
        <!-- Activation Modal -->
        <x-basics.modal show="showActivateModal" title="Lancer la commande"
            description="Confirmer l'activation du bon de commande">
            <p>Voulez-vous vraiment lancer cette commande ?</</p>
            <p>Cette action est irréversible.</p>
            <p class="text-sm text-gray-600 mt-2">
                La commande sera disponible pour les opérations de stock.
            </p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <form method="POST" action="{{ route('purchase-orders.activate', $purchaseOrder) }}"
                        class="inline w-full">
                        @csrf
                        <x-basics.button type="submit" variant="success" class="w-full">
                            <i class="ph ph-play-circle mr-2"></i>
                            Lancer la commande
                        </x-basics.button>
                    </form>
                </div>
            @endslot
        </x-basics.modal>
    @endif

    @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_CANCELLED)
        <!-- Reactivate Modal -->
        <x-basics.modal show="showReactivateModal" title="Réactiver le bon de commande"
            description="Confirmer la réactivation du bon de commande">
            <p>Voulez-vous vraiment réactiver ce bon de commande ?</p>
            <p class="text-sm text-gray-600 mt-2">
                Le bon de commande sera remis en statut "En attente" et pourra être reçu.
            </p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <form method="POST" action="{{ route('purchase-orders.reactivate', $purchaseOrder) }}"
                        class="inline w-full">
                        @csrf
                        <x-basics.button type="submit" variant="primary" class="w-full">
                            <i class="ph ph-arrow-clockwise mr-2"></i>
                            Réactiver
                        </x-basics.button>
                    </form>
                </div>
            @endslot
        </x-basics.modal>
    @endif

    @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_ACTIVE)
        <!-- Receive Modal -->
        <x-basics.modal show="showReceiveModal" title="Recevoir la commande"
            description="Confirmer la réception de la commande">
            <p>Voulez-vous vraiment recevoir cette commande ?</p>
            <p class="text-sm text-gray-600 mt-2">
                La commande sera marquée comme reçue.
            </p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <x-basics.button-link variant="success" class="w-full"
                        href="{{ route('purchase-orders.receive-form', $purchaseOrder) }}" target="_blank">
                        <i class="ph ph-check-circle mr-2"></i>
                        Recevoir
                    </x-basics.button-link>
                </div>
            @endslot
        </x-basics.modal>
    @endif

    @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_ACTIVE)
        <!-- Cancel Modal -->
        <x-basics.modal show="showCancelModal" title="Annuler la commande"
            description="Confirmer l'annulation de la commande">
            <p>Voulez-vous vraiment annuler la commande ?</p>
            <p class="text-sm text-gray-600 mt-2">
                La commande sera marquée comme annulée.
            <p class="text-sm text-red-600 mt-2">
                Cette action est irréversible.
            </p>
            </p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <form method="POST" action="{{ route('purchase-orders.cancel', $purchaseOrder) }}"
                        class="inline w-full">
                        @csrf
                        <x-basics.button type="submit" variant="danger" class="w-full">
                            <i class="ph ph-x-circle mr-2"></i>
                            Annuler
                        </x-basics.button>
                    </form>
                </div>
            @endslot
        </x-basics.modal>
    @endif

    @if (
        $purchaseOrder->status === App\Models\PurchaseOrder::STATUS_DRAFT ||
            $purchaseOrder->status === App\Models\PurchaseOrder::STATUS_CANCELLED)
        <!-- Delete Modal -->
        <x-basics.modal show="showDeleteModal" title="Supprimer la commande"
            description="Confirmer la suppression de la commande">
            <p>Voulez-vous vraiment supprimer la commande ?</p>
            <p class="text-sm text-gray-600 mt-2">
                La commande sera supprimée définitivement.
            <p class="text-sm text-red-600 mt-2">
                Cette action est irréversible.
            </p>
            </p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <form method="POST" action="{{ route('purchase-orders.destroy', $purchaseOrder) }}"
                        class="inline w-full">
                        @csrf
                        @method('DELETE')
                        <x-basics.button type="submit" variant="danger" class="w-full">
                            <i class="ph ph-trash mr-2"></i>
                            Supprimer
                        </x-basics.button>
                    </form>
                </div>
            @endslot
        </x-basics.modal>
    @endif

</div>
