@props(['saleType'])

<div class="space-y-6">
    <!-- Sale Type Info -->
    <x-basics.card title="Informations" subtitle="Détails du type de vente">
        <div class="space-y-3">

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut:</span>
                {!! $saleType->status_badge !!}
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Créé le:</span>
                <span class="text-sm font-medium text-gray-900">{{ $saleType->created_at->format('d/m/Y') }}</span>
            </div>
        </div>
    </x-basics.card>

    <!-- Tips -->
    <x-basics.card title="Conseils" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start space-x-2">
                <i class="ph ph-lightbulb text-blue-600 mt-0.5"></i>
                <p class="text-gray-600">
                    Les types de ventes permettent de catégoriser vos transactions.
                </p>
            </div>
            <div class="flex items-start space-x-2">
                <i class="ph ph-check-circle text-green-600 mt-0.5"></i>
                <p class="text-gray-600">
                    Désactivez un type de vente pour le rendre indisponible temporairement.
                </p>
            </div>
            <div class="flex items-start space-x-2">
                <i class="ph ph-warning text-orange-600 mt-0.5"></i>
                <p class="text-gray-600">
                    La suppression d'un type de vente est irréversible.
                </p>
            </div>
        </div>
    </x-basics.card>
</div>
