@props(['sale' => null])

<div class="space-y-6">
    @if($sale)
        <!-- Sale Status -->
        <x-basics.card title="Statut de la Vente">
            <div class="space-y-3 text-sm">

                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Statut:</span>
                    {!! $sale->getStatusBadge() !!}
                </div>


                <div class="flex items-center justify-between mb-6">
                    <span class="text-gray-600">Date:</span>
                    <span class="font-medium">{{ $sale->created_at->format('d/m/Y H:i') }}</span>
                </div>

                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Sous-total:</span>
                    <span class="font-medium">{{ number_format($sale->subtotal ?? 0, 0, ',', ' ') }} FC</span>
                </div>

                @if(($sale->tax_amount ?? 0) > 0)
                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Taxes:</span>
                    <span class="font-medium">{{ number_format($sale->tax_amount, 0, ',', ' ') }} FC</span>
                </div>
                @endif

                @if(($sale->discount_amount ?? 0) > 0)
                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Remise:</span>
                    <span class="font-medium text-red-600">-{{ number_format($sale->discount_amount, 0, ',', ' ') }} FC</span>
                </div>
                @endif

                <div class="border-t pt-3">
                    <div class="flex items-center justify-between">
                        <span class="font-bold text-gray-900">Total:</span>
                        <span class="font-bold text-blue-600">{{ number_format($sale->total_amount, 0, ',', ' ') }} FC</span>
                    </div>
                </div>

                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Montant payé:</span>
                    <span class="font-medium text-green-600">{{ number_format($sale->paid_amount ?? $sale->total_amount, 0, ',', ' ') }} FC</span>
                </div>

                @if(($sale->change_amount ?? 0) > 0)
                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Monnaie:</span>
                    <span class="font-medium">{{ number_format($sale->change_amount, 0, ',', ' ') }} FC</span>
                </div>
                @endif
                

            </div>
        </x-basics.card>
    @endif

    <!-- Sales Management -->
    <x-basics.card title="Gestion des Ventes" bodyBg="bg-orange-50">
        <div class="space-y-3 text-sm">
            <div class="flex items-center space-x-2">
                <i class="ph ph-shopping-cart text-blue-600"></i>
                <span class="text-gray-600">Enregistrement des transactions</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-credit-card text-green-600"></i>
                <span class="text-gray-600">Gestion des méthodes de paiement</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-receipt text-purple-600"></i>
                <span class="text-gray-600">Génération de factures</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-chart-line text-yellow-600"></i>
                <span class="text-gray-600">Analyse des performances</span>
            </div>
        </div>
    </x-basics.card>

    <!-- Tips -->
    <x-basics.card title="Conseils d'Utilisation" bodyBg="bg-yellow-50">
        <div class="space-y-3 text-sm">
            <p class="text-gray-600 text-justify">
                <strong>Vérification du stock :</strong> Vérifiez toujours la disponibilité des produits
                avant de confirmer une vente pour éviter les ruptures de stock.
            </p>
            <p class="text-gray-600 text-justify">
                <strong>Intégrité des données :</strong> Les ventes complétées ne peuvent plus être modifiées
                pour maintenir l'intégrité comptable et réglementaire.
            </p>
        </div>
    </x-basics.card>
    
</div>
