@props([
    'title',
    'value',
    'change' => null,
    'trend' => null,
    'icon',
    'color' => 'primary'
])

<div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow">
    <div class="flex items-center justify-between">
        <div>
            <p class="text-sm font-medium text-gray-600">{{ $title }}</p>
            <p class="text-2xl font-bold text-gray-900">{{ $value }}</p>
        </div>
        <div class="flex items-center space-x-2">
            @if($change && $trend)
                <span class="text-sm font-medium {{ $trend === 'up' ? 'text-green-600' : 'text-red-600' }}">
                    {{ $change }}
                </span>
            @endif
            <div class="w-8 h-8 bg-{{ $color }}-100 rounded-lg flex items-center justify-center">
                <span class="text-{{ $color }}-600 text-sm font-semibold">
                    {{ $icon }}
                </span>
            </div>
        </div>
    </div>
</div> 