@props([
    'merchant' => null,
    'showStats' => true,
    'showActions' => true,
    'compact' => false,
])

@if ($merchant)
    <x-basics.card class="min-h-[100%] hover:shadow-lg transition-shadow duration-300">
        <x-slot name="action">
            {!! $merchant->getStatusBadge() !!}
        </x-slot>

        <div class="space-y-4">
            <!-- Merchant Header -->
            <div class="">
                <!-- Logo/Image Placeholder -->
                <div class="flex justify-center">
                    <div class="w-54 h-54 bg-black rounded-full flex items-center justify-center">
                        @if ($merchant->photo_path)
                            <img src="{{ $merchant->photo_path }}" alt="{{ $merchant->name }}"
                                class="w-full h-full object-cover object-center rounded-full">
                        @else
                            <div class="w-full h-full flex items-center justify-center">
                                <span class="text-white text-6xl font-bold">
                                    {{ generate_avatar_data($merchant->name)['initials'] }}
                                </span>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Merchant Info -->
                <div class="flex-1 min-w-0 text-center">
                    <div class="mb-2">
                        <h3 class="text-lg font-semibold text-gray-900">
                            {{ $merchant->name }}
                        </h3>
                        <div class="flex justify-center text-sm text-gray-500">
                            {{ $merchant->slogan }}
                        </div>
                    </div>

                    <p class="text-sm text-gray-500 mt-1">
                        <i class="ph ph-map-pin mr-1"></i>
                        {{ $merchant->address->city->name ?? 'N/A' }}, {{ $merchant->address->province->name ?? 'N/A' }}
                    </p>
                    <p class="text-sm text-gray-500 mt-1">
                        <i class="ph ph-phone mr-1"></i>
                        {{ $merchant->contact->phone ?? 'N/A' }}
                    </p>
                    <div class="mt-2 flex justify-center space-x-2">
                        @if ($merchant->merchantType)
                            {!! $merchant->getTypeBadge() !!}
                        @endif

                        {!! $merchant->getStatusBadge() !!}
                    </div>
                </div>
            </div>

            <!-- Merchant Description -->
            @if ($merchant->description && !$compact)
                <div class="border-t border-gray-200 pt-4">
                    <p class="text-sm text-gray-600 leading-relaxed">
                        {{ Str::limit($merchant->description, 120) }}
                    </p>
                </div>
            @endif

            <!-- Stats Section -->
            @if ($showStats && !$compact)
                <div class="border-t border-gray-200 pt-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div class="text-center">
                            <div class="text-2xl font-bold text-blue-600">
                                {{ number_format($merchant->products()->count()) }}
                            </div>
                            <div class="text-xs text-gray-500">Produits</div>
                        </div>
                        <div class="text-center">
                            <div class="text-2xl font-bold text-green-600">
                                {{ number_format($merchant->sales()->count()) }}
                            </div>
                            <div class="text-xs text-gray-500">Ventes</div>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Quick Stats (Compact Mode) -->
            @if ($showStats && $compact)
                <div class="flex justify-between text-sm">
                    <span class="text-gray-600">
                        <i class="ph ph-package mr-1"></i>
                        {{ $merchant->products()->count() }} produits
                    </span>
                    <span class="text-gray-600">
                        <i class="ph ph-shopping-cart mr-1"></i>
                        {{ $merchant->sales()->count() }} ventes
                    </span>
                </div>
            @endif


            <x-slot name="footer">
                <!-- Additional Info -->
                @if (!$compact)
                    <div class=" border-gray-200">
                        <div class="flex justify-between text-xs text-gray-500">

                            @if ($merchant->status == \App\Models\Merchant::STATUS_DRAFT)
                                <span>
                                    <i class="ph ph-calendar mr-1"></i>
                                    Créé le {{ $merchant->created_at?->format('d/m/Y') }}
                                </span>
                            @endif

                        </div>
                    </div>
                @endif
                <!-- Actions -->
                @if ($showActions)
                    <div class="border-gray-200 pt-4 flex flex-col justify-between">

                        <x-basics.button-link href="{{ route('dashboard.merchants.show', $merchant) }}"
                            leftIcon="ph-eye" variant="primary" class="w-full mb-4">
                            Voir
                        </x-basics.button-link>

                        @if ($merchant->status == \App\Models\Merchant::STATUS_ACTIVE)
                            <div x-data="{ showDeactivateModal: false }">

                                <x-basics.button @click="showDeactivateModal = true" variant="danger" class="w-full"
                                    icon="<i class='ph ph-bold ph-trash'></i>" iconPosition="left">
                                    Désactiver l'établissement
                                </x-basics.button>

                                <form action="{{ route('dashboard.merchants.deactivate', $merchant) }}" method="POST">
                                    @csrf
                                    @method('PUT')
                                    <x-basics.modal show="showDeactivateModal" title="Désactiver l'établissement"
                                        description="Configurez votre établissement">

                                        <p>Voulez-vous vraiment désactiver l'établissement ?</p>
                                        <p>Cette action est irréversible.</p>


                                        @slot('footer')
                                            <div class="flex">
                                                <x-basics.button type="submit" class="w-full" variant="danger"
                                                    icon="<i class='ph ph-bold ph-trash'></i>" iconPosition="left">
                                                    Désactiver l'établissement
                                                </x-basics.button>
                                            </div>
                                        @endslot
                                    </x-basics.modal>
                                </form>

                            </div>
                        @endif


                    </div>
                @endif
            </x-slot>


        </div>
    </x-basics.card>
@else
    <x-basics.card class="min-h-[100%]">
        <div class="text-center py-8">
            <i class="ph ph-storefront text-4xl text-gray-300 mb-4"></i>
            <p class="text-gray-500">Aucun établissement disponible</p>
        </div>
    </x-basics.card>
@endif
