@props(['stockEntry'])

<x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
    <x-slot name="trigger">
        <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
            <i class="ph ph-dots-three-outline-vertical text-xl"></i>
        </button>
    </x-slot>

    <x-slot name="content">
        <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('stock-entries.show', $stockEntry) }}">
            Voir
        </x-basics.dropdown-item>


        @if ($stockEntry->status === App\Models\StockEntry::STATUS_DRAFT)
            <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('stock-entries.edit', $stockEntry) }}">
                Modifier
            </x-basics.dropdown-item>

            <x-basics.dropdown-item icon="ph ph-check-circle" variant="success" @click="showCompleteModal = true">
                Marquer comme complété
            </x-basics.dropdown-item>
        @endif

        <x-basics.dropdown-separator />

        @if ($stockEntry->product)
            <x-basics.dropdown-item icon="ph ph-package" href="{{ route('products.show', $stockEntry->product) }}">
                Voir le produit
            </x-basics.dropdown-item>
        @endif

        @if ($stockEntry->supplier)
            <x-basics.dropdown-item icon="ph ph-buildings" href="{{ route('suppliers.show', $stockEntry->supplier) }}">
                Voir le fournisseur
            </x-basics.dropdown-item>
        @endif

        @if ($stockEntry->purchaseOrder)
            <x-basics.dropdown-item icon="ph ph-receipt"
                href="{{ route('purchase-orders.show', $stockEntry->purchaseOrder) }}">
                Voir le bon de commande
            </x-basics.dropdown-item>
        @endif


        @if ($stockEntry->status === App\Models\StockEntry::STATUS_DRAFT)
            <x-basics.dropdown-separator />

            <x-basics.dropdown-item icon="ph ph-x-circle" variant="danger" @click="showCancelModal = true">
                Annuler
            </x-basics.dropdown-item>

            <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                Supprimer
            </x-basics.dropdown-item>
        @endif
    </x-slot>
</x-basics.dropdown>
