@props(['unit'])

<div class="space-y-6">
    <!-- Unit Statistics -->
    <x-basics.card title="Statistiques" subtitle="Informations sur l'utilisation de cette unité">
        <div class="space-y-4">
            <div class="flex items-center justify-between">
                <span class="text-sm font-medium text-gray-700">Produits utilisant cette unité</span>
                <span class="text-sm text-gray-600">{{ $unit->products->count() }}</span>
            </div>
            
            <div class="flex items-center justify-between">
                <span class="text-sm font-medium text-gray-700">Créée le</span>
                <span class="text-sm text-gray-600">{{ $unit->created_at->format('d/m/Y') }}</span>
            </div>
            
            @if($unit->updated_at != $unit->created_at)
                <div class="flex items-center justify-between">
                    <span class="text-sm font-medium text-gray-700">Modifiée le</span>
                    <span class="text-sm text-gray-600">{{ $unit->updated_at->format('d/m/Y') }}</span>
                </div>
            @endif
        </div>
    </x-basics.card>

    <!-- Tips -->
    <x-basics.card title="Conseils d'utilisation" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm">
            <p class="text-gray-600 text-justify">
                <strong>· Réutilisabilité:</strong> Créez des unités standard qui peuvent être utilisées pour plusieurs produits.
            </p>
            
            <p class="text-gray-600 text-justify">
                <strong>· Nomenclature:</strong> Utilisez des noms et symboles reconnus internationalement.
            </p>
            
            <p class="text-gray-600 text-justify">
                <strong>· Cohérence:</strong> Maintenez une cohérence dans l'utilisation des unités dans votre inventaire.
            </p>
        </div>
    </x-basics.card>
</div>
