@props(['user'])

<div x-data="{ showDeleteModal: false, showDeactivateModal: false, showActivateModal: false }">

    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('users.show', $user) }}" wire:navigate>
                Voir
            </x-basics.dropdown-item>

            <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('users.edit', $user) }}" wire:navigate>
                Modifier
            </x-basics.dropdown-item>

            <x-basics.dropdown-separator />

            <x-basics.dropdown-item icon="ph ph-clock" href="{{ route('users.activities', $user) }}" wire:navigate>
                Activités
            </x-basics.dropdown-item>

            @if ($user->status)
                <x-basics.dropdown-item icon="ph ph-pause-circle" variant="warning" @click="showDeactivateModal = true">
                    Désactiver
                </x-basics.dropdown-item>
            @else
                <x-basics.dropdown-item icon="ph ph-play-circle" variant="success" @click="showActivateModal = true">
                    Activer
                </x-basics.dropdown-item>
            @endif

            @if (!$user->status)
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                    Supprimer
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    <!-- Deactivate Modal -->
    <x-basics.modal show="showDeactivateModal" title="Désactiver l'utilisateur" description="Confirmer la désactivation de l'utilisateur">
        <p>Voulez-vous vraiment désactiver cet utilisateur ?</p>
        <p class="text-sm text-red-500 mt-2">
            L'utilisateur ne pourra plus se connecter à l'application et ne pourra pas accéder aux fonctionnalités de l'application.
        </p>

        @slot('footer')
            <div class="flex justify-end gap-3">
                <form method="POST" action="{{ route('users.deactivate', $user) }}" class="inline w-full">
                    @csrf
                    <x-basics.button type="submit" variant="danger" class="w-full">
                        <i class="ph ph-pause-circle mr-2"></i>
                        Désactiver l'utilisateur
                    </x-basics.button>
                </form>
            </div>
        @endslot
    </x-basics.modal>
    
    <!-- Activate Modal -->
    <x-basics.modal show="showActivateModal" title="Activer l'utilisateur" description="Confirmer l'activation de l'utilisateur">
        <p>Voulez-vous vraiment activer cet utilisateur ?</p>
        <p class="text-sm text-green-500 mt-2">
            L'utilisateur pourra se connecter à l'application et accéder aux fonctionnalités de l'application selon son rôle.
        </p>

        @slot('footer')
            <div class="flex justify-end gap-3">
                <form method="POST" action="{{ route('users.activate', $user) }}" class="inline w-full">
                    @csrf
                    <x-basics.button type="submit" variant="success" class="w-full">
                        <i class="ph ph-play-circle mr-2"></i>
                        Activer
                    </x-basics.button>
                </form>
            </div>
        @endslot
    </x-basics.modal>




    <!-- Delete Modal -->
    <x-basics.modal show="showDeleteModal" title="Supprimer l'utilisateur" description="Confirmer la suppression de l'utilisateur">
        <p>Voulez-vous vraiment supprimer cet utilisateur ?</p>
        <p class="text-sm text-red-500 mt-2">Cette action est irréversible.</p>

        @slot('footer')
            <div class="flex justify-end gap-3">
                <form method="POST" action="{{ route('users.destroy', $user) }}" class="inline w-full">
                    @csrf
                    @method('DELETE')
                    <x-basics.button type="submit" variant="danger" class="w-full">
                        <i class="ph ph-trash mr-2"></i>
                        Supprimer
                    </x-basics.button>
                </form>
            </div>
        @endslot
    </x-basics.modal>

</div>
