@props(['user'])

<div class="space-y-6">
    <x-basics.card title="Statut" subtitle="Statut de l'utilisateur">
        <div class="space-y-3">

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut:</span>
                {!! $user->status_badge !!}
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Créé le:</span>
                <span class="text-sm font-medium">{{ $user->created_at->format('d/m/Y') }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Modifié le:</span>
                <span class="text-sm font-medium">{{ $user->updated_at->format('d/m/Y') }}</span>
            </div>

        </div>
    </x-basics.card>

    <!-- Tips -->
    <x-basics.card title="Conseils d'Utilisation" bodyBg="bg-yellow-50">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start space-x-2">
                <i class="ph ph-lightbulb text-yellow-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Attribuez des rôles</strong> appropriés selon les responsabilités de chaque utilisateur.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-shield-check text-green-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Mettez à jour régulièrement</strong> les informations de contact des utilisateurs.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-warning text-orange-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Attention :</strong> Désactiver un utilisateur l'empêchera d'accéder au système.
                </p>
            </div>
        </div>
    </x-basics.card>

</div>
