<div>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Mon compte' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.account.dropdown :user="$user" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="container mx-auto flex flex-col lg:flex-row gap-6 mt-6">

        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">

            <!-- User Information -->
            <x-basics.card title="Informations de l'utilisateur" subtitle="Détails de l'utilisateur">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Full Name -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-user text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom complet</h3>
                                <p class="text-sm text-gray-600">{{ $user->firstname }} {{ $user->lastname }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Username -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-at text-gray-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom d'utilisateur</h3>
                                <p class="text-sm text-gray-600 font-mono">{{ $user->username }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Phone -->
                    @if ($user->phone)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-phone text-green-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Téléphone</h3>
                                    <p class="text-sm text-gray-600">{{ $user->phone }}</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Email -->
                    @if ($user->email)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-envelope-simple text-purple-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Email</h3>
                                    <p class="text-sm text-gray-600">{{ $user->email }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </x-basics.card>

            <!-- User Activities -->
            <x-basics.card title="Activités Récentes" subtitle="Les 10 dernières activités de cet utilisateur">
                @if ($user->activityLogs?->count() > 0)
                    <div class="space-y-4">
                        @foreach ($user->activityLogs()->latest()->limit(10)->get() as $activity)
                            <x-dashboard.activities-logs.item :activity="$activity" />
                        @endforeach
                    </div>

                    <div class="mt-4 pt-4 border-t border-gray-200">
                        <x-basics.button-link href="{{ route('activity-logs.user', $user) }}">
                            <i class="ph ph-list mr-2"></i>
                            Voir toutes les activités
                        </x-basics.button-link>
                    </div>
                @else
                    <div class="text-center py-8">
                        <div class="text-gray-500">
                            <i class="ph ph-activity text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucune activité enregistrée</p>
                            <p class="text-sm">Les activités de cet utilisateur apparaîtront ici</p>
                        </div>
                    </div>
                @endif
            </x-basics.card>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.account.sidebar :user="$user" />
        </div>
    </div>
</div>
