<div>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Mon compte' => route('account.index'),
        'Mot de passe' => null,
    ]">
        <x-slot name="action">
            <div class="flex items-center gap-2">
                <x-dashboard.account.dropdown :user="$user" />
            </div>
        </x-slot>
    </x-dashboard.breadcrumb>

    @include('components.basics.toast')

    <div class="container mx-auto flex flex-col lg:flex-row gap-6 mt-6">

        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <form wire:submit.prevent="save">
                <x-basics.card title="Mettre à jour le mot de passe"
                    subtitle="Assurez-vous d'utiliser un mot de passe fort">

                    <x-slot name="action">
                        <x-basics.flash :model="'success'" :timeout="3000"/>
                        <x-basics.flash :model="'error'" :message="$errorMessage" :timeout="3000"/>
                    </x-slot>

                    <div class="grid grid-cols-1 md:grid-cols-2">
                        <x-basics.input name="current_password" label="Mot de passe actuel" type="password" class="mb-4"
                            wire:model.live.debounce.1000ms="current_password" :error="$errors->first('current_password')" />
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2">
                        <x-basics.input name="password" label="Nouveau mot de passe" type="password" class="mb-4"
                            wire:model.live.debounce.1000ms="password" :error="$errors->first('password')" />
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2">
                        <x-basics.input name="password_confirmation" label="Confirmer le mot de passe" type="password"
                            class="mb-4" wire:model.live.debounce.1000ms="password_confirmation" :error="$errors->first('password_confirmation')" />
                    </div>

                    <x-slot name="footer">
                        <x-basics.button type="submit" class="w-full" :disabled="!$can_save || $loading" leftIcon="floppy-disk" wire:target="save">
                            @if($loading)
                                Enregistrement...
                            @else
                                Enregistrer les modifications
                            @endif
                        </x-basics.button>
                    </x-slot>

                </x-basics.card>

            </form>
        </div>


        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.account.sidebar :user="$user" />
        </div>

    </div>
</div>
