<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Server Error</title>
    <style>
        html, body { height: 100%; margin: 0; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Fira Sans", "Droid Sans", "Helvetica Neue", Arial, sans-serif; color: #111827; background: #F9FAFB; }
        .container { min-height: 100%; display: flex; align-items: center; justify-content: center; padding: 24px; }
        .card { width: 100%; max-width: 720px; background: #FFFFFF; border: 1px solid #E5E7EB; border-radius: 12px; box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1), 0 4px 6px -4px rgba(0,0,0,0.1); padding: 24px; }
        .title { font-size: 24px; font-weight: 700; margin: 0 0 8px; }
        .subtitle { font-size: 14px; color: #6B7280; margin: 0 0 16px; }
        .alert { background: #FEF2F2; color: #991B1B; border: 1px solid #FCA5A5; border-radius: 8px; padding: 12px 14px; font-size: 14px; margin-top: 12px; white-space: pre-wrap; word-break: break-word; }
        .meta { margin-top: 16px; font-size: 12px; color: #6B7280; }
        .small { font-size: 12px; color: #374151; }
    </style>
    @php($debug = (bool) config('app.debug'))
</head>
<body>
    <div class="container">
        <div class="card">
            <h1 class="title">Something went wrong (500)</h1>
            <p class="subtitle">An unexpected error occurred. Please try again.</p>

            @if(isset($exception) && $debug)
                <div class="alert">
                    {{ $exception->getMessage() }}
                </div>
                @if($exception->getFile())
                    <div class="meta">{{ $exception->getFile() }} : line {{ $exception->getLine() }}</div>
                @endif
            @elseif($debug && session('error_message'))
                <div class="alert">{{ session('error_message') }}</div>
            @endif

            <div class="small" style="margin-top:16px;">
                @if($debug)
                    Debug is enabled. Detailed error shown above.
                @else
                    Debug is disabled. Enable APP_DEBUG to see details during development.
                @endif
            </div>
        </div>
    </div>
</body>
</html>


