<x-layouts.dashboard>
    <div class="container mx-auto max-w-4xl">
        <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Conditions d\'utilisation' => null,
        ]" />

        <div class="mt-6">
            <x-basics.card title="Conditions d'utilisation" subtitle="Dernière mise à jour: {{ date('d/m/Y') }}">
                <div class="prose prose-gray max-w-none">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">1. Acceptation des conditions</h3>
                    <p class="text-gray-700 mb-6">
                        En utilisant l'application Ango, vous acceptez d'être lié par ces conditions d'utilisation. 
                        Si vous n'acceptez pas ces conditions, veuillez ne pas utiliser notre application.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">2. Description du service</h3>
                    <p class="text-gray-700 mb-6">
                        Ango est une application de gestion pharmaceutique conçue pour aider les pharmacies et dépôts 
                        à gérer leurs stocks, ventes, clients et autres opérations commerciales de manière efficace.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">3. Utilisation autorisée</h3>
                    <div class="text-gray-700 mb-6">
                        <p class="mb-3">Vous vous engagez à utiliser l'application uniquement pour :</p>
                        <ul class="list-disc pl-6 space-y-2">
                            <li>Gérer votre établissement pharmaceutique de manière légale et conforme</li>
                            <li>Respecter toutes les réglementations en vigueur</li>
                            <li>Maintenir la confidentialité des données de vos clients</li>
                            <li>Ne pas utiliser l'application à des fins illégales ou non autorisées</li>
                        </ul>
                    </div>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">4. Propriété intellectuelle</h3>
                    <p class="text-gray-700 mb-6">
                        L'application Ango et tout son contenu sont protégés par les droits d'auteur et autres 
                        droits de propriété intellectuelle. Vous ne pouvez pas copier, modifier ou distribuer 
                        l'application sans autorisation écrite.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">5. Confidentialité des données</h3>
                    <p class="text-gray-700 mb-6">
                        Nous nous engageons à protéger vos données conformément à notre politique de confidentialité. 
                        Vous êtes responsable de la sécurité de vos identifiants de connexion et de toutes les 
                        activités effectuées sous votre compte.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">6. Limitation de responsabilité</h3>
                    <p class="text-gray-700 mb-6">
                        L'application est fournie "en l'état". Nous ne garantissons pas que l'application sera 
                        exempte d'erreurs ou disponible en permanence. Nous ne serons pas responsables des dommages 
                        indirects résultant de l'utilisation de l'application.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">7. Modification des conditions</h3>
                    <p class="text-gray-700 mb-6">
                        Nous nous réservons le droit de modifier ces conditions d'utilisation à tout moment. 
                        Les modifications prendront effet dès leur publication sur l'application.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">8. Résiliation</h3>
                    <p class="text-gray-700 mb-6">
                        Nous nous réservons le droit de suspendre ou résilier votre accès à l'application 
                        en cas de violation de ces conditions d'utilisation.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">9. Droit applicable</h3>
                    <p class="text-gray-700 mb-6">
                        Ces conditions d'utilisation sont régies par le droit congolais. Tout litige sera 
                        soumis à la juridiction des tribunaux compétents de la République Démocratique du Congo.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">10. Contact</h3>
                    <p class="text-gray-700 mb-6">
                        Pour toute question concernant ces conditions d'utilisation, veuillez nous contacter 
                        à l'adresse email de support de l'application.
                    </p>
                </div>

                <x-slot name="footer">
                    <div class="flex justify-between items-center">
                        <x-basics.link href="{{ route('home') }}" variant="secondary">
                            <i class="ph ph-arrow-left mr-2"></i>
                            Retour au tableau de bord
                        </x-basics.link>
                        <x-basics.link href="{{ route('privacy') }}" variant="primary">
                            Politique de confidentialité
                            <i class="ph ph-arrow-right ml-2"></i>
                        </x-basics.link>
                    </div>
                </x-slot>
            </x-basics.card>
        </div>
    </div>
</x-layouts.dashboard>
